PSCAD 4.2.0

Settings
 {
 Id = "1035389062.1130180117"
 Author = "bathiya.jayas"
 Desc = "Ind. Generator driven by a wind turbine"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 60
  Step = 5e-005
  Plot = 0.00025
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }

 }

Definitions
 {
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1130174547
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Landscape,144,[619,473],100)
   {
   0.source3([306,432],0,0,-1)
    {
    Name = "Source1"
    Type = "2"
    Ctrl = "0"
    MVA = "2.5 [MVA]"
    Vm = "0.398 [kV]"
    F = "50.0 [Hz]"
    Tc = "0.00 [s]"
    ZSeq = "0"
    Imp = "0"
    Exph = "0"
    View = "1"
    Term = "0"
    R1s = "1.0 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.00001 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    R0p = "1.0 [ohm]"
    L0p = "0.1 [H]"
    Z0 = "1.0 [ohm]"
    Phi0 = "80.0 [deg]"
    Es = "0.398 [kV]"
    F0 = "50.0 [Hz]"
    Ph = "0.0 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    VCtrl = "0"
    Vdes = "1.0 [pu]"
    Vbase = "230.0 [kV]"
    Tvm = "0.02 [s]"
    Tvc = "0.05 [s]"
    PCtrl = "0"
    Pdes = "1.0 [pu]"
    Tpm = "0.02 [s]"
    Tpc = "0.05 [s]"
    P = ""
    Q = ""
    V = ""
    Theta = ""
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Wire-([540,432],0,0,-1)
    {
    Vertex="0,0;-198,0"
    }
   0.compare([756,432],4,0,130)
    {
    X = "1"
    OL = "1"
    OH = "0"
    INTR = "0"
    }
   0.time-sig([828,432],4,0,20)
    {
    }
   0.ground([270,432],4,0,-1)
    {
    }
   -Wire-([54,306],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([54,342],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([54,306],0,0,-1)
    {
    Name = "P"
    }
   0.datalabel([54,342],0,0,-1)
    {
    Name = "Q"
    }
   0.pgb([126,342],0,29832968,270)
    {
    Name = "Q"
    Group = ""
    Display = "0"
    Scale = "2"
    Units = "MVar"
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   -Wire-([270,270],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.pgb([270,270],0,29836360,300)
    {
    Name = "w"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "1.0128"
    Max = "1.0132"
    }
   0.pgb([270,342],0,29839384,260)
    {
    Name = "Tm"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-0.82"
    Max = "-0.72"
    }
   0.pgb([270,306],0,29842280,280)
    {
    Name = "Te"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-0.82"
    Max = "-0.72"
    }
   0.pgb([126,306],0,29845200,290)
    {
    Name = "P"
    Group = ""
    Display = "0"
    Scale = "2"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "0.0"
    }
   0.datalabel([198,270],4,0,-1)
    {
    Name = "w"
    }
   0.pgb([810,666],0,29848976,250)
    {
    Name = "Tturbine"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "0.766"
    Max = "0.78"
    }
   0.pgb([810,702],0,29851736,240)
    {
    Name = "PT"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.datalabel([648,846],0,0,-1)
    {
    Name = "BETA"
    }
   0.pgb([648,846],0,29855512,230)
    {
    Name = "Beta"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "16.2"
    Max = "16.4"
    }
   0.var([144,666],0,29858272,30)
    {
    Name = "Es"
    Group = ""
    Display = "0"
    Max = "30"
    Min = "0.0"
    Value = "5"
    Units = ""
    Collect = "1"
    }
   -Wire-([180,666],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([216,666],0,0,-1)
    {
    Name = "ES"
    }
   0.datalabel([450,666],0,0,-1)
    {
    Name = "Vw"
    }
   0.wind_turbine([648,684],0,0,200)
    {
    Gmva = "2 [MVA]"
    Wrat = "1000 [rpm]"
    Rad = "40 [m]"
    Area = "5026 [m*m]"
    Airden = "1.229 [kg/m^3]"
    Eff = "0.97 [pu]"
    Gratio = "GR"
    Mod = "0"
    }
   0.var([918,882],0,29864216,90)
    {
    Name = "GR"
    Group = ""
    Display = "0"
    Max = "200"
    Min = "0.0"
    Value = "55.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([954,882],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1026,882],0,0,-1)
    {
    Name = "GR"
    }
   -Wire-([558,774],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.compare([306,1026],0,0,120)
    {
    X = "5"
    OL = "0"
    OH = "1"
    INTR = "0"
    }
   0.time-sig([234,1026],0,0,110)
    {
    }
   -Wire-([54,270],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([54,270],0,0,-1)
    {
    Name = "Vw"
    }
   0.pgb([126,270],0,29876104,310)
    {
    Name = "Wind speed"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "m/s"
    mrun = "0"
    Pol = "0"
    Min = "14.9"
    Max = "15.1"
    }
   0.datalabel([198,342],4,0,-1)
    {
    Name = "Tm"
    }
   0.wind_governor([648,972],0,0,190)
    {
    Pcnt = "1"
    Gen = "0"
    Wrat = "50 [Hz]"
    Tmva = "2 [MW]"
    Gmva = "2 [MVA]"
    Gov = "0"
    Gr = "GR"
    Pref = "1.44 [MW]"
    Wref = "314 [rad/s]"
    Kp = "6.2 [deg/pu]"
    Ki = "6.2 "
    Piul = "100"
    Pill = "-100"
    Ks = "0.05 [deg/pu]"
    Gmul = "30 [deg/pu]"
    Dwm = "0.2 [rad/s]"
    Bo = "16.35 [deg]"
    K4 = "0.1 [s]"
    Arl = "1"
    Rl = "10.0 [deg/s]"
    Pal = "1"
    Bll = "0 [deg]"
    Bul = "25 [deg]"
    Nf = "0"
    Type = "5"
    Wf = "10.0 [rad/s]"
    Df = "0.3"
    }
   0.datalabel([414,954],0,0,-1)
    {
    Name = "P"
    }
   -Wire-([648,918],0,0,-1)
    {
    Vertex="0,0;0,-162"
    }
   0.select([540,990],0,0,180)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([360,1026],4,0,-1)
    {
    Name = "CNT"
    }
   0.const([468,990],0,0,100)
    {
    Name = ""
    Value = "0.72"
    }
   -Wire-([342,1026],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([486,954],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([234,1080],0)
    {
    Name = ""
    Font = 1
    Bounds = 234,1080,396,1134
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Signal CNT enables the pitch angle dynamics"
    }
   -Sticky-([468,846],0)
    {
    Name = ""
    Font = 1
    Bounds = 468,846,594,918
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
A six Pole Machine
Mechanical speed = W(pu)*2*pi*f/(pole paris)
"
    }
   -Wire-([558,702],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([720,666],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([720,702],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([360,666],0,0,-1)
    {
    Vertex="0,0;216,0"
    }
   0.wind_source([288,666],0,0,40)
    {
    EXT = "1"
    BWV = "10 [m/s]"
    Gust = "0"
    Ramp = "0"
    Noise = "0"
    Damp = "0"
    TC = "0.025 [s]"
    MAXG = "1 [m/s]"
    TG = "2 [s]"
    T1G = "3"
    NG = "1"
    MAXR = "1 [m/s]"
    TR = "1 [s]"
    T1R = "6"
    NR = "1"
    N = "50"
    DW = "1 [rad/s]"
    Kn = "0.0192"
    F = "600 [m]"
    ISEED = "8"
    TRM = "0.35 [s]"
    }
   -Sticky-([54,72],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,72,432,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case shows a induction generator being driven by a wind turbine. The turbine is controled by a wind governor. The 'wind source'  is used to model wind speed fluctuations.

"
    }
   -Sticky-([882,774],0)
    {
    Name = ""
    Font = 1
    Bounds = 882,774,1044,846
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
GR - Gear Ratio
Es - External signal for wind speed
"
    }
   -Wire-([360,1026],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   0.const([270,774],0,0,50)
    {
    Name = ""
    Value = "1.0"
    }
   -Wire-([270,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.select([342,774],0,0,140)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([270,738],0,0,-1)
    {
    Name = "w"
    }
   0.datalabel([342,810],0,0,-1)
    {
    Name = "CNT"
    }
   0.mult([450,774],0,0,150)
    {
    }
   -Wire-([378,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.div([522,774],0,0,160)
    {
    }
   0.const([486,810],0,0,60)
    {
    Name = "Pole pairs"
    Value = "3"
    }
   -Wire-([810,666],0,0,-1)
    {
    Vertex="0,0;0,-198;-90,-198"
    }
   -Sticky-([432,702],0)
    {
    Name = ""
    Font = 1
    Bounds = 432,702,540,738
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "\
Actual hub speed of machine
"
    }
   -Sticky-([432,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 432,18,1080,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "WIND FARM - INDUCTION MACHINE"
    }
   -Wire-([720,432],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.const([684,396],4,0,10)
    {
    Name = ""
    Value = "1.01308"
    }
   0.datalabel([198,306],4,0,-1)
    {
    Name = "Te"
    }
   0.gain([684,468],4,0,210)
    {
    G = "-1"
    COM = "Gain"
    Dim = "1"
    }
   0.sqc100([576,432],4,0,220)
    {
    Name = "wind gen"
    Cnfg = "1"
    MM = "0"
    NOM = "1.0"
    Iter = "1"
    Vbase = "0.23 [kV]"
    Ibase = "2.9 [kA]"
    OMO = "50.0 [Hz]"
    View = "1"
    HP = "3000 [hp]"
    noname1 = ""
    noname2 = ""
    noname3 = ""
    noname4 = ""
    noname5 = ""
    MSat = "0"
    LSat = "0"
    R1 = "0.066 [pu]"
    R2 = "0.298 [pu]"
    R3 = "0.018 [pu]"
    XL0 = "0.046 [pu]"
    XM0 = "3.86 [pu]"
    X230 = "0.122 [pu]"
    X3 = "0.105 [pu]"
    J = "5 [s]"
    D = "0.008 [pu]"
    DRatio = "1.0 [pu]"
    PFFLD = "0.85 [pu]"
    EFFLD = "0.985 [pu]"
    SFLD = "0.015 [pu]"
    CSTA = "5.0 [pu]"
    TRAT = "1.5 [pu]"
    TQMAX = "3.0 [pu]"
    Poles = "4"
    HINERT = "10.0"
    Hunit = "0"
    D2 = "0.008 [pu]"
    I1M = "0.0 [pu]"
    V1M = "1.0 [pu]"
    I2M = "1.0 [pu]"
    V2M = "1.0 [pu]"
    I3M = "2.0 [pu]"
    V3M = "0.9 [pu]"
    I4M = "3.0 [pu]"
    V4M = "0.8 [pu]"
    I5M = "4.0 [pu]"
    V5M = "0.7 [pu]"
    I6M = "5.0 [pu]"
    V6M = "0.6 [pu]"
    I7M = "5.1 [pu]"
    V7M = "0.59 [pu]"
    I8M = "5.2 [pu]"
    V8M = "0.58 [pu]"
    I9M = "5.3 [pu]"
    V9M = "0.57 [pu]"
    I10M = "5.4 [pu]"
    V10M = "0.56 [pu]"
    I1 = "0.0 [pu]"
    V1 = "0.0 [pu]"
    I2 = "1.196 [pu]"
    V2 = "0.286 [pu]"
    I3 = "1.82 [pu]"
    V3 = "0.4 [pu]"
    I4 = "2.861 [pu]"
    V4 = "0.564 [pu]"
    I5 = "5.882 [pu]"
    V5 = "0.981 [pu]"
    I6 = "-1.0 [pu]"
    V6 = "-1.0 [pu]"
    I7 = "-1.0 [pu]"
    V7 = "-1.0 [pu]"
    I8 = "-1.0 [pu]"
    V8 = "-1.0 [pu]"
    I9 = "-1.0 [pu]"
    V9 = "-1.0 [pu]"
    I10 = "-1.0 [pu]"
    V10 = "-1.0 [pu]"
    POut = "P"
    QOut = "Q"
    Theta = ""
    Tmech = "Tm"
    SP = "w"
    Telec = "Te"
    Tangle = ""
    Tslip = ""
    sfmi = ""
    sfli = ""
    }
   0.gain([450,954],0,0,170)
    {
    G = "-1"
    COM = "Gain"
    Dim = "1"
    }
   -Sticky-([576,1044],0)
    {
    Name = ""
    Font = 1
    Bounds = 576,1044,774,1152
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "\
Initial Pitch angle and the Power reference (demand) are inputs to this module.
For this example :
Initial pitch angle = 16.35 deg
Power demand = 1.44 MW"
    }
   -Sticky-([594,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 594,522,792,594
    Alignment = 0
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "The convention for the Induction machine is that input mechanical torque is negative . (ie. motoring mode is positive)"
    }
   -Sticky-([468,324],0)
    {
    Name = ""
    Font = 2
    Bounds = 468,324,792,360
    Alignment = 0
    Style = 0
    Arrow = 2
    Color = 0,15792890
    Text = "A 50 Hz, low voltage power system"
    }
   -SrcFile-([576,72],0)
    {
   Name = "IM_wind_mod2.mcd"
    }
   -Sticky-([882,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 882,954,1044,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "When in steady state, apply a step change (using the slider) to ES. The pitch angle will regulate the real power to the power order (Demand) requested from the governor."
    }
   -Sticky-([774,216],0)
    {
    Name = ""
    Font = 1
    Bounds = 774,216,1062,342
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
1.01358 is approximately the pu speed of the machine when delivering 1.44 MW (0.77 pu) of power to the system. This is used as the initial seep to spped up the initialization of the silulation.

If the starting transients are of interest, then the initial speed should be zero and the machine should start in the 'Torque control' mode."
    }
   -Sticky-([756,72],0)
    {
    Name = ""
    Font = 1
    Bounds = 756,72,1062,162
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
Turbine troque equations are included in the Mathcad file.
At a wind speed of 15 [m/s], a pitch angle of 14 [deg] will result in the turbine providing the required steady state torque.

"
    }
   -Sticky-([162,540],0)
    {
    Name = ""
    Font = 1
    Bounds = 162,540,396,594
    Alignment = 0
    Style = 1
    Arrow = 2
    Color = 0,15792890
    Text = "Use this component to study a wind gust or a ramp and see the response of the control systems."
    }
   -Wire-([198,306],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([198,342],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.annotation([180,216],0,0,-1)
    {
    AL1 = "Output Cnahhels for Plotting"
    AL2 = ""
    }
   0.emtconst([324,864],0,0,70)
    {
    Name = ""
    Value = "1"
    }
   0.gain([396,864],0,0,80)
    {
    G = "50.0"
    COM = "freq"
    Dim = "1"
    }
   -Wire-([432,864],0,0,-1)
    {
    Vertex="0,0;18,0;18,-54"
    }
   -ControlPanel-([900,594],0)
    {
    Name = "Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 900,594
    Extents = 0,0,144,126
    Slider(29858272)
    Slider(29864216)
    }
   -Plot-([1080,54],0)
    {
    Title = "Plots"
    Draw = 1
    Area = [0,0,468,1116]
    Posn = [1080,54]
    Icon = [864,558]
    Extents = 0,0,468,1116
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,468,132],"Power")
     {
     Options = 0
     Units = ""
     Curve(29845200,"P",0,,,)
     }
    Graph([0,132],[0,0,468,132],"Reactive Power")
     {
     Options = 0
     Units = ""
     Curve(29832968,"Q",0,,,)
     }
    Graph([0,264],[0,0,468,132],"Mc. Elec. Spd.")
     {
     Options = 0
     Units = ""
     Curve(29836360,"w",0,,,)
     }
    Graph([0,396],[0,0,468,132],"Mech. Torque")
     {
     Options = 0
     Units = ""
     Curve(29839384,"Tm",0,,,)
     }
    Graph([0,528],[0,0,468,132],"Elec. Torque")
     {
     Options = 0
     Units = ""
     Curve(29842280,"Te",0,,,)
     }
    Graph([0,660],[0,0,468,131],"Torque")
     {
     Options = 0
     Units = ""
     Curve(29848976,"Tturbine",0,,,)
     }
    Graph([0,791],[0,0,468,131],"Wind Speed")
     {
     Options = 0
     Units = ""
     Curve(29876104,"Wind speed",0,,,)
     }
    Graph([0,922],[0,0,468,131],"Pitch Angle")
     {
     Options = 0
     Units = ""
     Curve(29855512,"Beta",0,,,)
     }
    }
   }
  }
 }

